﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO

Public Class DirectoryInfoPanel
    Inherits FileSystemSample.FileSystemInfoBasePanel

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents BackgroundWorker1 As System.ComponentModel.BackgroundWorker

    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.BackgroundWorker1 = New System.ComponentModel.BackgroundWorker
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.Text = "The DirectoryInfo class encapsulates information related to directories on the fi" & _
            "le system."
        '
        'BackgroundWorker1
        '
        Me.BackgroundWorker1.WorkerReportsProgress = False
        Me.BackgroundWorker1.WorkerSupportsCancellation = False
        '
        'DirectoryInfoPanel
        '
        Me.Name = "DirectoryInfoPanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Shared panelInstance As DirectoryInfoPanel
    Friend WithEvents directoryChooser As New DirectoryChooser
    Private dirInfo As DirectoryInfo
    Private dirSize As Long

    ''' <summary>
    ''' 获取该面板的全局实例。
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As DirectoryInfoPanel
        If (panelInstance Is Nothing) Then
            panelInstance = New DirectoryInfoPanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并为 My.Computer.FileSystem.GetDirectoryInfo 中的 directory 参数添加一个控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub GetDirectoryInfo_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("directory", directoryChooser)
    End Sub


    ''' <summary>
    ''' 初始化该面板上的控件，并将每个控件设置为其默认值
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.GetDirectoryInfo("
        directoryChooser.AutoSize = True
        directoryChooser.Reset()
        SetDirectoryInfo()
    End Sub


    ''' <summary>
    ''' 为指定的目录获取 directoryInfo 对象
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        SetDirectoryInfo()
    End Sub


    ''' <summary>
    ''' 设置该面板上的所有目录信息
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub SetDirectoryInfo()
        If (Me.directoryChooser.Directory <> String.Empty) Then
            dirInfo = My.Computer.FileSystem.GetDirectoryInfo(CType(Me.directoryChooser.Directory, String))
            Me.nameLabel.Text = dirInfo.Name
            Me.locationLabel.Text = dirInfo.FullName
            Me.sizeLabel.Text = "Calculating..."
            Me.createdLabel.Text = dirInfo.CreationTime.ToString
            Me.modifiedLabel.Text = dirInfo.LastWriteTime.ToString
            Me.accessedLabel.Text = dirInfo.LastWriteTime.ToString

            ' 计算目录大小需要较长的时间，因此我们将在后台执行此操作
            Me.BackgroundWorker1.RunWorkerAsync()
        Else
            Me.nameLabel.Text = String.Empty
            Me.locationLabel.Text = String.Empty
            Me.sizeLabel.Text = String.Empty
            Me.createdLabel.Text = String.Empty
            Me.modifiedLabel.Text = String.Empty
            Me.accessedLabel.Text = String.Empty
        End If
    End Sub

    ''' <summary>
    ''' 将这些面板控件重置为它们的默认值
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

    ''' <summary>
    ''' DirectoryInfo 不返回目录大小，因此必须手动计算其大小。我们通过
    ''' 计算选定目录中每个文件和子目录的大小来计算该目录的大小。由于该方法使用了递归，因此它不是
    ''' 计算目录大小的最有效方法。
    ''' </summary>
    ''' <param name="dir"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function GetDirectorySize(ByVal dir As DirectoryInfo) As Long
        Dim directorySize As Long = 0

        '首先累加目录中所有文件的大小
        For Each f As FileInfo In dir.GetFiles()
            directorySize += f.Length
        Next

        '然后，递归计算每个子目录的大小
        For Each subDir As DirectoryInfo In dir.GetDirectories()
            directorySize += GetDirectorySize(subDir)
        Next
        Return directorySize
    End Function

    ''' <summary>
    ''' 在后台计算目录大小。使用后台辅助线程可以根据计算出的大小更新 UI。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BackgroundWorker1_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        '该方法将在除 UI 线程之外的线程上运行。
        '一定不要在 UI 线程上使用该方法
        '操作所创建的任何 Windows 窗体控件。
        Me.dirSize = Me.GetDirectorySize(dirInfo)
    End Sub

    ''' <summary>
    ''' 用目录大小更新 UI
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BackgroundWorker1_RunWorkerCompleted(ByVal sender As Object, ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs) Handles BackgroundWorker1.RunWorkerCompleted
        Me.sizeLabel.Text = Me.dirSize.ToString
    End Sub
End Class
